//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_METAINFOASSETBUILDERBASE_H)
#define CANDERA_METAINFOASSETBUILDERBASE_H

#include <Candera/Environment.h>
#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>
#include <Candera/System/Diagnostics/Log.h>

namespace Candera { 
    namespace Internal {

        class MetaInfoAssetBuilderBase
        {
        public:
            MetaInfoAssetBuilderBase() {};
            virtual ~MetaInfoAssetBuilderBase() {};
            bool Read(CffLoaderContext& context);
        protected:
            FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);
            virtual bool SetProperty(const Char* name, const Char* value, DependencyList* reloadList) = 0;
        };

    }
}

#endif  // CANDERA_METAINFOASSETBUILDERBASE_H
