//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_METAINFOASSETBUILDER_H)
#define CANDERA_METAINFOASSETBUILDER_H

#include <Candera/System/MetaInfo/PropertyMetaInfo.h>
#include <Candera/System/MetaInfo/ObjectMetaInfo.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/MetaInfoAssetBuilderBase.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>

namespace Candera {
    namespace Internal {

        template <typename T, typename PMI = MetaInfo::PropertyMetaInfo<T>, typename MI = MetaInfo::ObjectMetaInfo<T, PMI> >
        class MetaInfoAssetBuilder: public MetaInfoAssetBuilderBase {
        public:
            MetaInfoAssetBuilder(T& object, const MI& objectMetaInfo): m_object(object), m_objectMetaInfo(objectMetaInfo) {}

        protected:
            virtual bool SetProperty(const Char* name, const Char* value, DependencyList* reloadList) 
            {
                PMI* propertyMetaInfo = m_objectMetaInfo.LookupItem(name);
                if (propertyMetaInfo == 0) {
                    return false;
                }

                bool createDependency = true;
                if (!DefaultAssetProvider::GetInstance().IsIterativeLoadingEnabled()) {
                    createDependency = !SetPropertyInternal(m_object, *propertyMetaInfo, value);
                }
                if (createDependency) {
                    ItemPathInfo path(value);
                    if ((path.IsPathValid()) && (reloadList != 0)) {
                        typedef MetaInfoPropertyDependencyLoader<T, PMI> MIDependencyLoader;
                        return reloadList->Append(DependencyEntry(ASSETLOADER_TRANSIENT_NEW(MIDependencyLoader)(m_object, *propertyMetaInfo, value, &SetPropertyInternal)));
                    }
                    else {
                        return SetPropertyInternal(m_object, *propertyMetaInfo, value);
                    }
                }
                else {
                    return true;
                }
            }

        private:
            CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1725, CANDERA_LINT_REASON_ASSOCIATION)
            T& m_object;
            CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1725, CANDERA_LINT_REASON_ASSOCIATION)
            const MI& m_objectMetaInfo;

            CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1704, CANDERA_LINT_REASON_NONCOPYABLE)
            FEATSTD_MAKE_CLASS_UNCOPYABLE(MetaInfoAssetBuilder);

            static bool SetPropertyInternal(T& object, PMI& propertyMetaInfo, const Char* value) 
            {
                return propertyMetaInfo.Set(&object, value);
            }
        };
    }
}

#endif  // CANDERA_METAINFOASSETBUILDER_H
