//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LayouterAssetBuilder.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/LayoutCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/StackLayouterAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/GridLayouterAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/BaseLineLayouterAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/OverlayLayouterAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/DockPanelLayouterAssetBuilder.h>

#include <Candera/EngineBase/Layout/StackLayouter.h>
#include <Candera/EngineBase/Layout/GridLayouter.h>
#include <Candera/EngineBase/Layout/BaseLineLayouter.h>
#include <Candera/EngineBase/Layout/OverlayLayouter.h>
#include <Candera/EngineBase/Layout/DockPanelLayouter.h>

namespace Candera {
    using namespace Diagnostics;

    namespace Internal {
        Layouter* LayouterAssetBuilder::CreateAndBuildFirstPass(LoaderContext& context)
        {
            Layouter* ret = 0;
            switch (CFFReader::GetLayoutLayoutType(context.handle)) {
            case NoLayouter: ret = 0; break;
            case Stack: ret = AssetBuilder<StackLayouter*>::CreateAndBuildFirstPass(context);break;
            case Grid: ret = AssetBuilder<GridLayouter*>::CreateAndBuildFirstPass(context);break;
            case BaseLine: ret = AssetBuilder<BaseLineLayouter*>::CreateAndBuildFirstPass(context);break;
            case Overlay: ret = AssetBuilder<OverlayLayouter*>::CreateAndBuildFirstPass(context);break;
            case DockPanel: ret = AssetBuilder<DockPanelLayouter*>::CreateAndBuildFirstPass(context);break;
            default: FEATSTD_DEBUG_FAIL(); break; // Shouldn't go here, all types must be covered
            }

            return ret;
        }

        bool LayouterAssetBuilder::BuildSecondPass(Layouter* layouter, LoaderContext& context)
        {
            using FeatStd::Internal::PointerToPointer;

            bool ret = false;
            switch (CFFReader::GetLayoutLayoutType(context.handle)) {
                case NoLayouter: 
                    ret = false; 
                    break;

                case Stack: 
                    ret = AssetBuilder<StackLayouter*>::BuildSecondPass(PointerToPointer<StackLayouter*>(layouter), context);
                    break;

                case Grid: 
                    ret = AssetBuilder<GridLayouter*>::BuildSecondPass(PointerToPointer<GridLayouter*>(layouter), context);
                    break;

                case BaseLine: 
                    ret = AssetBuilder<BaseLineLayouter*>::BuildSecondPass(PointerToPointer<BaseLineLayouter*>(layouter), context);
                    break;

                case Overlay: 
                    ret = AssetBuilder<OverlayLayouter*>::BuildSecondPass(PointerToPointer<OverlayLayouter*>(layouter), context);
                    break;

                case DockPanel: 
                    ret = AssetBuilder<DockPanelLayouter*>::BuildSecondPass(PointerToPointer<DockPanelLayouter*>(layouter), context);
                    break;

                default: 
                    FEATSTD_DEBUG_FAIL(); 
                    break; // Shouldn't go here, all types must be covered
            }

            return ret;
        }
    }
}
