//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LanguagePackAssetBuilder.h"
#include <Candera/System/GlobalizationBase/LanguagePack.h>
#include <CanderaPlatform/OS/StringPlatform.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/LanguagePackCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderMemoryPool.h>

namespace Candera {

    using namespace Diagnostics;
    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);
        namespace Internal {

        using namespace Globalization;


        /******************************************************************************
         *  Culture::SharedPointer - Create
         ******************************************************************************/
#if defined(CANDERA_GLOBALIZATION_ENABLED)
        Candera::Globalization::Culture::SharedPointer AssetBuilderBase<Candera::Globalization::Culture::SharedPointer>::Create(LoaderContext& context)
        {
            using namespace Globalization;

            Culture::SharedPointer culture;

            LanguagePack::SharedPointer languagePack = context.provider->GetLanguagePackByAssetId(context.id);
            if (languagePack.PointsToNull()){
                FEATSTD_LOG_WARN("GetLanguagePackByAssetId returns a null pointer.");
            }

            if (languagePack != 0) {
                culture = Culture::Create();

                if (culture != 0) {
                    // locale
                    const Char* localeStr = languagePack->GetLocale();
                    SizeType length = StringPlatform::Length(localeStr);
                    Char* locale = ASSETLOADER_TRANSIENT_NEW_ARRAY(Char, length + 1);
                    if (locale != 0) {
                        StringPlatform::Copy(locale, localeStr);
                        culture->SetLocale(locale);
                    }

                    // display name
                    const TChar* displayNameStr = languagePack->GetDisplayName();
                    length = StringPlatform::Length(reinterpret_cast<const Char*>(displayNameStr));
                    TChar* displayName = ASSETLOADER_TRANSIENT_NEW_ARRAY(TChar, length + 1);
                    if (displayName != 0) {
                        StringPlatform::Copy(reinterpret_cast<Char*>(displayName), reinterpret_cast<const Char*>(displayNameStr));
                        culture->SetDisplayName(displayName);
                    }

                    // text direction
                    culture->SetTextDirection(languagePack->GetTextDirection());
                }
            }

            return culture;
        }
#else
        Candera::Globalization::Culture::SharedPointer AssetBuilderBase<Candera::Globalization::Culture::SharedPointer>::Create(LoaderContext& /*context*/)
        {
            return Globalization::Culture::SharedPointer();
        }
#endif
        /******************************************************************************
         *  Culture::SharedPointer - Dispose
         ******************************************************************************/
        void AssetBuilderBase<Culture::SharedPointer>::Dispose(Culture::SharedPointer culture)
        {
            FEATSTD_DELETE_ARRAY(culture->GetLocale());
            culture->SetLocale(0);

            FEATSTD_DELETE_ARRAY(culture->GetDisplayName());
            culture->SetDisplayName(0);
        }
    }
}
