//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GRIDLAYOUTER_BUILDER_H)
#define CANDERA_GRIDLAYOUTER_BUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/LayouterAssetBuilder.h>

namespace Candera {
    class GridLayouter;
    namespace Internal {
        AssetLoaderTypeInfo(Candera::GridLayouter, CffLoaderType, Candera::Layouter);

        template<>
        class AssetReaderBase<GridLayouter>: public GenericAssetReaderBase<GridLayouter> {
        public:
            static bool ReadFirstPass(GridLayouter& layouter, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<GridLayouter*>: public GenericAssetBuilderBase<GridLayouter*> {
        public:
            static GridLayouter* Create(LoaderContext& context);
        };
    }
}

#endif  // CANDERA_GRIDLAYOUTER_BUILDER_H
