//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GridLayouterAssetBuilder.h"
#include <Candera/EngineBase/Layout/GridLayouter.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/GridLayoutCffReader.h>

namespace Candera {
    using namespace Diagnostics;

    namespace Internal {

        bool AssetReaderBase<GridLayouter>::ReadFirstPass(GridLayouter& layouter, LoaderContext& context)
        {
            UInt8 rowCount = CFFReader::GetGridLayoutRowCount(context.handle);
            UInt8 columnCount = CFFReader::GetGridLayoutColumnCount(context.handle);

            layouter.SetLayout(rowCount, columnCount);

            for (UInt8 rowIndex = 0; rowIndex < rowCount; rowIndex++) {
                layouter.SetRowHeight(rowIndex, CFFReader::GetGridLayoutRowHeightsElementAt(context.handle, rowIndex));
            }

            for (UInt8 columnIndex = 0; columnIndex < columnCount; columnIndex++) {
                layouter.SetColumnWidth(columnIndex, CFFReader::GetGridLayoutColumnWidthsElementAt(context.handle, columnIndex));
            }

            return true;
        }

        GridLayouter* AssetBuilderBase<GridLayouter*>::Create(LoaderContext& /*context*/)
        {
            return GridLayouter::Create();
        }
    }
}
