//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GraphicDeviceUnitAssetBuilder.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageInterface.h>
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnit.h>
#include <CanderaPlatform/Device/Common/Base/DeviceMetaInfo.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/RenderTargetCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/MetaInfoAssetBuilder.h>

namespace Candera {
    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);
    using namespace Diagnostics;
    using namespace MetaInfo;

    namespace Internal {

        bool AssetReaderBase<GraphicDeviceUnit>::ReadSecondPass(GraphicDeviceUnit& gdu, LoaderContext& context)
        {
            GraphicDeviceUnitTypeHandle gduTypeHandle = gdu.GetUnitType();

            const DeviceMetaInfo* gduMetaInfo = DevicePackageDescriptor::GetMetaInformation(gduTypeHandle);
            if (gduMetaInfo == 0) {
                return false;
            }

            MetaInfoAssetBuilder<DeviceMetaInfoHost, DevicePropertyMetaInfo, DeviceMetaInfo> metaInfoReader(gdu, *gduMetaInfo);
            if (metaInfoReader.Read(context)) {

                Int dummy;
                Candera::Internal::AssetId result = AssetIdFunctions::GetAssetId(CFFReader::GetRenderTargetDisplay_CFFSerializable(context.handle));
                if (!result.IsValid()) {
                    FEATSTD_LOG_DEBUG("GetAssetId is not valid");
                }
                Int resultDisplay = context.provider->GetDisplayDataByAssetId(result, dummy, dummy);
                gdu.SetDisplay(resultDisplay);
                return true;
            } else {
                return false;
            }
        }

        GraphicDeviceUnit* AssetBuilderBase<GraphicDeviceUnit*>::Create(LoaderContext& context)
        {
            context.reloadList = 0;
            const Char* gduType = AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetDynamicItemCanderaTypeName(context.handle));
            DevicePackageDescriptor::UnitCategory category = static_cast<DevicePackageDescriptor::UnitCategory>(CFFReader::GetRenderTargetRenderTargetType(context.handle));

            Int dummy;
            Candera::Internal::AssetId result = AssetIdFunctions::GetAssetId(CFFReader::GetRenderTargetDisplay_CFFSerializable(context.handle));
            if (!result.IsValid()) {
                FEATSTD_LOG_DEBUG("Render target display not found!");
            }
            Int displayHandle = DefaultAssetProvider::GetInstance().GetDisplayDataByAssetId(result, dummy, dummy);
            Int handleCount = 0;
            const GraphicDeviceUnitTypeHandle* handles = DevicePackageDescriptor::GetUnitTypes(category, displayHandle, handleCount);

            for (Int handleIndex = 0; handleIndex < handleCount; ++handleIndex) {
                const GraphicDeviceUnitMetaInfo* gduMetaInfo = DevicePackageDescriptor::GetMetaInformation(handles[handleIndex]);
                if (StringPlatform::CompareStrings(gduType, gduMetaInfo->GetName()) == 0) {
                    GraphicDeviceUnit* gdu = DevicePackageInterface::CreateGraphicDeviceUnit(handles[handleIndex]);
                    if (gdu != 0) {
                        gdu->SetName(AssetProviderFunctions::GetName(context.provider, context.repositoryId, CFFReader::GetCanderaObjectCanderaName(context.handle)));
                    }
                    return gdu;
                }
            }

            return 0;
        }

        void AssetBuilderBase<GraphicDeviceUnit*>::Dispose(GraphicDeviceUnit* gdu)
        {
            DevicePackageInterface::DestroyGraphicDeviceUnit(gdu);
        }
    }
}
