//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DISPLAYASSETBUILDER_H)
#define CANDERA_DISPLAYASSETBUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    class Display;
    namespace Internal {

        class DisplayData {
        public:
            Int m_id;
            Int m_width;
            Int m_height;
        };

        AssetLoaderTypeInfo(DisplayData, CffLoaderType, void);

        template<>
        class AssetReaderBase<DisplayData>: public GenericAssetReaderBase<DisplayData> {
        public:
            static bool ReadFirstPass(DisplayData& displayData, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<DisplayData*>: public GenericAssetBuilderBase<DisplayData*> {
        public:
            static DisplayData* Create(LoaderContext& context);
            static void Dispose(DisplayData* displayData);
        };

        AssetLoaderTypeInfo(Candera::Display, CffLoaderType, void);
        
        template<>
        class AssetBuilderBase<Display*>: public GenericAssetBuilderBase<Display*> {
        public:
            static Display* Create(CffLoaderContext& context);
        };
    }
}

#endif  // CANDERA_DISPLAYASSETBUILDER_H
