//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DisplayAssetBuilder.h"

#include <CanderaPlatform/Device/Common/Base/Display.h>
#include <CanderaPlatform/Device/Common/Base/DeviceMetaInfo.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageDescriptor.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageInterface.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/DisplayCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderMemoryPool.h>

#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/MetaInfoAssetBuilder.h>

namespace Candera {
    namespace Internal {
        FEATSTD_LOG_SET_REALM(Candera::Diagnostics::LogRealm::CanderaAssetLoader);

        bool AssetReaderBase<DisplayData>::ReadFirstPass(DisplayData& displayData, LoaderContext& context)
        {
            displayData.m_id = CFFReader::GetDisplayDisplayId(context.handle);
            displayData.m_width = CFFReader::GetDisplayResolutionX(context.handle);
            displayData.m_height = CFFReader::GetDisplayResolutionY(context.handle);

            return true;
        }

        DisplayData* AssetBuilderBase<DisplayData*>::Create(LoaderContext& /*context*/)
        {
            return ASSETLOADER_TRANSIENT_NEW(DisplayData);
        }

        void AssetBuilderBase<DisplayData*>::Dispose(DisplayData* displayData)
        {
            ASSETLOADER_DELETE(displayData);
        }

        Display* AssetBuilderBase<Display*>::Create(CffLoaderContext& context)
        {
            Display* display = DevicePackageInterface::GetDisplay(CFFReader::GetDisplayDisplayId(context.handle));
            if (display == 0) {
                return 0;
            }
            const MetaInfo::DeviceMetaInfo* metaInfo =
                DevicePackageDescriptor::GetDisplayMetaInformation(display->GetDisplayId());
            if (metaInfo == 0) {
                return display;
            }

            MetaInfoAssetBuilder<Display, MetaInfo::DevicePropertyMetaInfo, MetaInfo::DeviceMetaInfo> metaInfoReader(*display, *metaInfo);
            if (!metaInfoReader.Read(context)) {
                FEATSTD_LOG_WARN("Display meta info assetbuilder read failed.");
            }

            return display;
        }
    }
}
