//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CameraGroupAssetBuilder.h"
#include <Candera/EngineBase/Common/CameraGroup.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/CameraGroupCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>

#ifdef CANDERA_2D_ENABLED
#include <Candera/Engine2D/Core/Camera2D.h>
#endif
#ifdef CANDERA_3D_ENABLED
#include <Candera/Engine3D/Core/Camera.h>
#endif

namespace Candera {
    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);
    namespace Internal {
        bool AssetReaderBase<CameraGroup>::ReadFirstPass(CameraGroup& cameraGroup, LoaderContext& context)
        {
            Int32 cameraCount = CFFReader::GetCameraGroupCamerasLength(context.handle);
            for (Int cameraIndex = 0; cameraIndex < cameraCount; ++cameraIndex) {
                AssetId cameraAssetId = AssetIdFunctions::GetAssetId(CFFReader::GetCameraGroupCamerasElementAt(context.handle, cameraIndex));
                if (!cameraAssetId.IsValid()) {
                    FEATSTD_LOG_DEBUG("GetAssetId is not valid");
                }
#ifdef CANDERA_2D_ENABLED
                Node2D* resultNode = context.provider->GetNode2DByAssetId(cameraAssetId);
                Camera2D* camera2D = Dynamic_Cast<Camera2D*>(resultNode);
                if (camera2D != 0) {
                    cameraGroup.AddCamera2D(camera2D);
                }
#endif
#ifdef CANDERA_3D_ENABLED
                Node* result = context.provider->GetNodeByAssetId(cameraAssetId);
                Camera* camera = Dynamic_Cast<Camera*>(result);
                if (camera != 0) {
                    cameraGroup.AddCamera(camera);
                }
#endif
            }
            return true;
        }

        CameraGroup* AssetBuilderBase<CameraGroup*>::Create(LoaderContext& /*context*/)
        {
            return FEATSTD_NEW(CameraGroup);
        }

        void AssetBuilderBase<CameraGroup*>::Dispose(CameraGroup* cameraGroup)
        {
            if (cameraGroup != 0) {
                FEATSTD_DELETE(cameraGroup);
            }
        }
    }
}
