//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BITMAPASSETBUILDER_H)
#define CANDERA_BITMAPASSETBUILDER_H

#include <Candera/EngineBase/Common/Bitmap.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Bitmap, CffLoaderType, CanderaObject);

        template<>
        class AssetReaderBase<Bitmap>: public GenericAssetReaderBase<Bitmap> {
        public:
            static bool ReadFirstPass(Bitmap& bitmap, LoaderContext& context);
            static bool ReadSecondPass(Bitmap& bitmap, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Bitmap::SharedPointer> : public GenericAssetBuilderBase<Bitmap::SharedPointer> {
        public:

            static Bitmap::SharedPointer Create(LoaderContext& context, Id id);
            static Bitmap::SharedPointer Create(LoaderContext& context);
        };

        typedef AssetBuilderBase<Bitmap::SharedPointer> BitmapAssetBuilder;
    }
}

#endif  // CANDERA_BITMAPASSETBUILDER_H
