//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AnimationPlayerBaseAssetReader.h"
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/AnimationBaseCffReader.h>

namespace Candera {
    namespace Internal {

        bool AssetReaderBase<Animation::AnimationPlayerBase>::ReadFirstPass(Animation::AnimationPlayerBase& animationPlayerBase, LoaderContext& context)
        {
            animationPlayerBase.SetRepeatCount(CFFReader::GetAnimationBaseRepeatCount(context.handle));
            animationPlayerBase.SetSpeedFactor(CFFReader::GetAnimationBaseSpeedFactor(context.handle));
            animationPlayerBase.SetStringId(animationPlayerBase.GetName(), 0);

            return true;
        }
    }
}
