//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ANIMATIONPLAYERASSETBUILDER_H)
#define CANDERA_ANIMATIONPLAYERASSETBUILDER_H

#include <Candera/EngineBase/Animation/AnimationPlayer.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Animation::AnimationPlayer, CffLoaderType, Animation::AnimationPlayerBase);

        template<>
        class AssetReaderBase<Animation::AnimationPlayer>: public GenericAssetReaderBase<Animation::AnimationPlayer> {
        public:
            static bool ReadFirstPass(Animation::AnimationPlayer& animationPlayer, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<Animation::AnimationPlayer> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<Animation::AnimationPlayer> > {
        public:
            static MemoryManagement::SharedPointer<Animation::AnimationPlayer> Create(LoaderContext& context);
        };
    }
}
#endif  // CANDERA_ANIMATIONPLAYERASSETBUILDER_H
