//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ANIMATIONBLENDEDPROPERTYLIST_READER_H)
#define CANDERA_ANIMATIONBLENDEDPROPERTYLIST_READER_H

#include <Candera/Environment.h>
#include <Candera/EngineBase/Animation/AnimationTimeType.h>
#include <Candera/EngineBase/Animation/AnimationPlayer.h>
#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {

    namespace Animation {
        class AnimationBlendedProperty;
        class KeyframeSequence;
    }
    class SceneContextBase;

    namespace Internal {

        class AnimationBlendedPropertyListAssetReader {
        public:
            AnimationBlendedPropertyListAssetReader(AssetId animationId, Animation::AnimationPlayer::SharedPointer animation);
            virtual ~AnimationBlendedPropertyListAssetReader() {};
            bool Read(CffLoaderContext& context);
        protected:
            Animation::AnimationPlayer::SharedPointer m_animation;
            AssetId m_animationId;
        private:
            bool ReadKeyframeSequence(MemoryManagement::SharedPointer<Animation::KeyframeSequence> keyframeSequence, const CffLoaderContext& context, Int32 channelCount, Int32 channelIndex) const;

            virtual Int32 GetAnimationPropertyCount(CffLoaderContext& context) = 0;
            virtual AssetDataHandle GetAnimationProperty(CffLoaderContext& context, Int32 index) = 0;

            virtual bool AddAnimationBlendedProperty(const MemoryManagement::SharedPointer<Animation::AnimationBlendedProperty>& property) = 0;

            enum InterpolationStrategyType
            {
                StepInterpolation,      ///< Discrete steps
                LinearInterpolation,    ///< Linear interpolation
                SplineInterpolation,    ///< Spline interpolation
                BezierInterpolation,    ///< Bezier curve interpolation
                EaseInterpolation       ///< Ease in/out interpolation
            };

            enum EaseFunctionType
            {
                EaseFunctionBack,           ///< Back
                EaseFunctionBounce,         ///< Bouncing ease function
                EaseFunctionElastic,        ///< Elastic ease function
                EaseFunctionExponential,    ///< Exponential ease function
                EaseFunctionPower           ///< Power ease function
            };
        };

        class SceneAnimationBlendedPropertyListAssetReader: public AnimationBlendedPropertyListAssetReader {
        public:
            SceneAnimationBlendedPropertyListAssetReader(AssetId animationId, Animation::AnimationPlayer::SharedPointer animation);
            virtual ~SceneAnimationBlendedPropertyListAssetReader() {};
        private:
            virtual Int32 GetAnimationPropertyCount(CffLoaderContext& context) override;
            virtual AssetDataHandle GetAnimationProperty(CffLoaderContext& context, Int32 index) override;

            virtual bool AddAnimationBlendedProperty(const MemoryManagement::SharedPointer<Animation::AnimationBlendedProperty>& /*property*/) { return true; }
        };

        class SceneContextAnimationBlendedPropertyListAssetReader: public SceneAnimationBlendedPropertyListAssetReader {
        public:
            SceneContextAnimationBlendedPropertyListAssetReader(SceneContextBase& sceneContext, AssetId animationId, Animation::AnimationPlayer::SharedPointer animation);
            virtual ~SceneContextAnimationBlendedPropertyListAssetReader() {};
        private:
            CANDERA_SUPPRESS_LINT_FOR_NEXT_EXPRESSION(1725, CANDERA_LINT_REASON_ASSOCIATION)
                SceneContextBase& m_sceneContext;

            virtual bool AddAnimationBlendedProperty(const MemoryManagement::SharedPointer<Animation::AnimationBlendedProperty>& property);

            FEATSTD_MAKE_CLASS_UNCOPYABLE(SceneContextAnimationBlendedPropertyListAssetReader);
        };

    }
}

#endif  // CANDERA_ANIMATIONBLENDEDPROPERTYLIST_READER_H
