//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "AbstractNodePointerDataType.h"

namespace Candera {

    namespace MetaInfo {

        namespace Internal {

            bool DataType< Candera::AbstractNodePointer>::ConvertFromString(Candera::AbstractNodePointer &destination, const Char *buf, AssetProvider* provider)
            {
                return AssetLoaderConverterFromString< Candera::AbstractNodePointer, &AssetProvider::GetNodePointerByAssetId>::ConvertFromString(destination, buf, provider);
            }

            const Char* DataType< Candera::AbstractNodePointer>::GetEditor()
            {
                return "builtin://NodeEditor";
            }
        }
    }
}
