//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_VERTEXBUFFER_BUILDER_H
#define CANDERA_VERTEXBUFFER_BUILDER_H

#include <Candera/Engine3D/Core/VertexBuffer.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    namespace Internal {

        AssetLoaderTypeInfo(Candera::VertexBuffer, CffLoaderType, Candera::CanderaObject);

        template<>
        class AssetReaderBase<VertexBuffer>: public GenericAssetReaderBase<VertexBuffer> {
        public:
            static bool ReadFirstPass(VertexBuffer& vertexBuffer, LoaderContext& context);
            static VertexGeometry* CreateVertexGeometry(LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<VertexBuffer> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<VertexBuffer> > {
        public:
            static MemoryManagement::SharedPointer<VertexBuffer> Create(LoaderContext& context);
        };

        typedef MemoryManagement::SharedPointer<Candera::VertexBuffer> VertexBufferPtr;
        typedef AssetBuilderBase<VertexBufferPtr> VertexBufferBuilder;
        typedef AssetReaderBase<VertexBuffer> VertexBufferReader;
    }
}
#endif // CANDERA_VERTEXBUFFER_BUILDER_H
