//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_SHADERPARAMSETTER_BUILDER_H
#define CANDERA_SHADERPARAMSETTER_BUILDER_H

#include <Candera/Engine3D/ShaderParamSetters/GenericShaderParamSetter.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    namespace Internal {

        AssetLoaderTypeInfo(Candera::GenericShaderParamSetter, CffLoaderType, Candera::CanderaObject);

        template<>
        class AssetReaderBase<GenericShaderParamSetter>: public GenericAssetReaderBase<GenericShaderParamSetter> {
        public:
            static bool ReadFirstPass(GenericShaderParamSetter& shaderParamSetter, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<GenericShaderParamSetter> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<GenericShaderParamSetter> > {
        public:
            static MemoryManagement::SharedPointer<GenericShaderParamSetter> Create(LoaderContext& context);
        };
    }
}

#endif // CANDERA_SHADERPARAMSETTER_BUILDER_H
