//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_SHADER_BUILDER_H
#define CANDERA_SHADER_BUILDER_H

#include <Candera/Engine3D/Core/Shader.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Shader, CffLoaderType, Candera::CanderaObject);

        template<>
        class AssetReaderBase<Shader>: public GenericAssetReaderBase<Shader> {
        public:
            static bool ReadFirstPass(Shader& shader, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<Shader> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<Shader> > {
        public:
            static MemoryManagement::SharedPointer<Shader> Create(LoaderContext& context);
        };

        typedef Candera::MemoryManagement::SharedPointer<Candera::Shader> ShaderPtr;
        typedef Candera::Internal::AssetBuilderBase<ShaderPtr> ShaderBuilder;
        typedef Candera::Internal::AssetReaderBase<Candera::Shader> ShaderReader;
    }
}
#endif // CANDERA_SHADER_BUILDER_H
