//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SCENECONTEXTASSET_BUILDER_H)
#define CANDERA_SCENECONTEXTASSET_BUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/SceneContextBaseAssetReader.h>

namespace Candera {
    class SceneContext;
    namespace Internal {

        AssetLoaderTypeInfo(SceneContext, CffLoaderType, SceneContextBase);

        template<>
        class AssetReaderBase<SceneContext>: public GenericAssetReaderBase<SceneContext> {
        public:
            static bool ReadSecondPass(SceneContext& sceneContext, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<SceneContext*>: public GenericAssetBuilderBase<SceneContext*> {
        public:
            static SceneContext* Create(LoaderContext& context);
            static void Dispose(SceneContext* sceneContext);
            static bool IsValid(const SceneContext* sceneContext, LoaderContext& context);
        };
    }
}

#endif  // CANDERA_SCENECONTEXTASSET_BUILDER_H
