//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SCENE_BUILDER_H)
#define CANDERA_SCENE_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/GroupAssetBuilder.h>

namespace Candera {
    class Scene;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Scene, CffLoaderType, Candera::CanderaObject);

        template<>
        class AssetReaderBase<Scene>: public GenericAssetReaderBase<Scene> {
        public:
            enum SupportedOrderCriterion {
                DistanceToCamera = 0,           ///< Distance to camera, front to back.
                ReverseDistanceToCamera = 1,    ///< Reverse distance to camera, back to front.
                RenderOrderRank = 2,            ///< Order rank descending.
                ReverseRenderOrderRank = 3,     ///< Order rank ascending.      
                BatchOrder = 4                  ///< Order by batch.
            };

            static bool ReadFirstPass(Scene& scene, LoaderContext& context);
            static bool ReadSecondPass(Scene& scene, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Scene*>: public GenericAssetBuilderBase<Scene*> {
        public:
            static Scene* Create(LoaderContext& context);
        };

        class SceneNodeChildrenReader: public NodeChildrenReader {
        protected:
            virtual Int32 GetChildrenCount(CffLoaderContext& context) const;
            virtual AssetDataHandle GetChildDataHandle(CffLoaderContext& context, Int32 index) const;
        };
    }
}


#endif  // CANDERA_SCENE_BUILDER_H
