//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_RENDERMODE_BUILDER_H
#define CANDERA_RENDERMODE_BUILDER_H

#include <Candera/Engine3D/Core/RenderMode.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    namespace Internal {

        AssetLoaderTypeInfo(Candera::RenderMode, CffLoaderType, Candera::CanderaObject);

        template<>
        class AssetReaderBase<RenderMode>: public GenericAssetReaderBase<RenderMode> {
        public:
            static bool ReadFirstPass(RenderMode& renderMode, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<RenderMode> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<RenderMode> > {
        public:
            static MemoryManagement::SharedPointer<RenderMode> Create(LoaderContext& context);

            /**
             *  Creates a the default RenderMode from the asset file.
             *  @return MemoryManagement::SharedPointer to the created RenderMode. May be null if no DefaultRenderMode was found in asset file.
             */
            static MemoryManagement::SharedPointer<RenderMode> CreateDefaultRenderMode(LoaderContext& context);
        };
    }
}
#endif // CANDERA_RENDERMODE_BUILDER_H
