//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_REFLECTIONCAMERA_BUILDER_H
#define CANDERA_REFLECTIONCAMERA_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/CameraAssetBuilder.h>

namespace Candera {
    class ReflectionCamera;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::ReflectionCamera, CffLoaderType, Candera::Camera);

        template<>
        class AssetReaderBase<ReflectionCamera>: public GenericAssetReaderBase<ReflectionCamera> {
        public:
            static bool ReadSecondPass(ReflectionCamera& reflectionCamera, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<ReflectionCamera*>: public GenericAssetBuilderBase<ReflectionCamera*> {
        public:
            static ReflectionCamera* Create(LoaderContext& context);
        };
    }
}
#endif // CANDERA_REFLECTIONCAMERA_BUILDER_H
