//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_REFERENCEDTEMPLATE_BUILDER_H
#define CANDERA_REFERENCEDTEMPLATE_BUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    class Node;

    namespace Internal {
        struct ReferencedTemplate {
            Node* m_node;
        };
        AssetLoaderTypeInfo(ReferencedTemplate, CffLoaderType, void);

        template<>
        class AssetBuilderBase<ReferencedTemplate*>: public GenericAssetBuilderBase<ReferencedTemplate*> {
        public:
            static ReferencedTemplate* Create(LoaderContext& context);
            static void Dispose(ReferencedTemplate* referencedTemplate);
        };
    }
}

#endif // CANDERA_REFERENCEDTEMPLATE_BUILDER_H
