//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_LODNODE_BUILDER_H)
#define CANDERA_LODNODE_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>

namespace Candera {
    class LodNode;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::LodNode, CffLoaderType, Node);

        template<>
        class AssetReaderBase<LodNode>: public GenericAssetReaderBase<LodNode> {
        public:
            static bool ReadFirstPass(LodNode& lodNode, LoaderContext& context);

        private:
            enum LodStrategyType
            {
                LodStrategyTypeDiscrete,    ///< Discrete lod strategy.
                LodStrategyTypeBlend        ///< Blended lod strategy.
            };

            enum LodCriterionType
            {
                LodCriterionTypeDistanceToCamera,   ///< Use distance to camera for lod.
                LodCriterionTypeGeneric             ///< Lod criterion is set manually.
            };
        };

        template<>
        class AssetBuilderBase<LodNode*>: public GenericAssetBuilderBase<LodNode*> {
        public:
            static LodNode* Create(LoaderContext& context);
            static void Dispose(const LodNode* lodNode);
        };
    }
}


#endif  // CANDERA_LODNODE_BUILDER_H
