//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LightAssetBuilder.h"
#include <Candera/Engine3D/Core/Light.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/LightCffReader.h>

namespace Candera {

    using namespace Diagnostics;

    namespace Internal {

        Light* AssetBuilderBase<Light*>::Create(LoaderContext& /*context*/)
        {
            return Light::Create();
        }

        bool AssetReaderBase<Light>::ReadFirstPass(Light& light, LoaderContext& context)
        {
            Float f1 = 0.0F;
            Float f2 = 0.0F;
            Float f3 = 0.0F;
            Float f4 = 0.0F;

            light.SetType(static_cast<Light::Type>(CFFReader::GetLightLightType(context.handle)));
            CFFReader::GetLightAmbient(context.handle, f1, f2, f3, f4);
            light.SetAmbient(Color(f1, f2, f3, f4));
            CFFReader::GetLightDiffuse(context.handle, f1, f2, f3, f4);
            light.SetDiffuse(Color(f1, f2, f3, f4));
            CFFReader::GetLightSpecular(context.handle, f1, f2, f3, f4);
            light.SetSpecular(Color(f1, f2, f3, f4));
            CFFReader::GetLightDirection(context.handle, f1, f2, f3);
            light.SetDirection(Vector3(f1, f2, f3));
            light.SetRange(CFFReader::GetLightRange(context.handle));
            light.SetAttenuation(CFFReader::GetLightConstantAttenuation(context.handle),
                CFFReader::GetLightLinearAttenuation(context.handle),
                CFFReader::GetLightQuadraticAttenuation(context.handle));

            light.SetSpotAngle(CFFReader::GetLightSpotAngle(context.handle));
            light.SetSpotExponent(CFFReader::GetLightSpotExponent(context.handle));
            light.SetAttenuationEnabled(CFFReader::GetLightIsAttenuationEnabled(context.handle));

            return true;
        }
    }
}
