//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GROUP_BUILDER_H)
#define CANDERA_GROUP_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>

namespace Candera {
    class Group;
    namespace Internal {
        AssetLoaderTypeInfo(Group, CffLoaderType, Node);

        template<>
        class AssetReaderBase<Group> : public GenericAssetReaderBase<Group>{
        public:
            static bool ReadFirstPass(Group& group, LoaderContext& context);
            static bool ReadSecondPass(Group& group, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Group*>: public GenericAssetBuilderBase<Group*> {
        public:
            static Group* Create(LoaderContext& context);
            static void Dispose(const Group* group);
        };
    }
}


#endif  // CANDERA_GROUP_BUILDER_H
