//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CANVASTEXT_BUILDER_H)
#define CANDERA_CANVASTEXT_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>

namespace Candera {
    class CanvasText;
    namespace Internal {
        AssetLoaderTypeInfo(CanvasText, CffLoaderType, Node);

        template<>
        class AssetBuilderBase<CanvasText*> : public GenericAssetBuilderBase<CanvasText*>{
        public:
            static CanvasText* Create(LoaderContext& context);
        };
        template<>
        class AssetReaderBase<CanvasText> : public GenericAssetReaderBase<CanvasText>{
        public:
            static bool ReadFirstPass(CanvasText& canvasText, const LoaderContext& context);
        };
    }
}


#endif  // CANDERA_CANVASTEXT_BUILDER_H
