//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CanvasRenderableAssetReader.h"
#include <Candera/Engine3D/Canvas/CanvasRenderable.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/CanvasRenderableCffReader.h>

namespace Candera {
    namespace Internal {

        using namespace Diagnostics;

        bool AssetReaderBase<CanvasRenderable>::ReadFirstPass(CanvasRenderable& canvasRenderable, LoaderContext& context)
        {
            canvasRenderable.SetTargetTexture(CFFReader::GetCanvasRenderableTargetTexture(context.handle));
            Float rect[4];
            CFFReader::GetCanvasRenderableRectangle(context.handle, rect[0], rect[1], rect[2], rect[3]);
            canvasRenderable.SetVertexRectangle(Rectangle(rect[0], rect[1], rect[2], rect[3]));

            return true;
        }
    }
}
