//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BITMAPTEXTUREIMAGE_BUILDER_H)
#define CANDERA_BITMAPTEXTUREIMAGE_BUILDER_H

#include <Candera/Engine3D/Core/BitmapTextureImage.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    namespace Internal {

        AssetLoaderTypeInfo(Candera::BitmapTextureImage, CffLoaderType, CanderaObject);

        template<>
        class AssetReaderBase<BitmapTextureImage>: public GenericAssetReaderBase<BitmapTextureImage> {
            public:
                static bool ReadFirstPass(BitmapTextureImage& bitmapTextureImage, LoaderContext& context);
                static bool SetBitmap(BitmapTextureImage& bitmapTextureImage, AssetId id, DependencyList* dependencyList, const DefaultAssetProvider* provider);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<BitmapTextureImage> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<BitmapTextureImage> > {
            public:
                static MemoryManagement::SharedPointer<BitmapTextureImage> Create(LoaderContext& context);
        };
    }
}

#endif  // CANDERA_BITMAPTEXTUREIMAGE_BUILDER_H
