//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_BILLBOARD_BUILDER_H
#define CANDERA_BILLBOARD_BUILDER_H

#include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>

namespace Candera {
    class Billboard;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Billboard, CffLoaderType, Candera::Node);

        template<>
        class AssetReaderBase<Billboard>: public GenericAssetReaderBase<Billboard> {
        public:
            static bool ReadFirstPass(Billboard& billboard, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Billboard*>: public GenericAssetBuilderBase<Billboard*> {
        public:
            static Billboard* Create(LoaderContext& context);
        };
    }
}


#endif // CANDERA_BILLBOARD_BUILDER_H
