//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_APPEARANCE_BUILDER_H)
#define CANDERA_APPEARANCE_BUILDER_H

#include <Candera/Engine3D/Core/MultiPassAppearance.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CanderaObjectAssetReader.h>

namespace Candera {
    namespace Internal {
        enum SharedAttachmentType {
            MissingAttachment,      ///< No attachment.
            NotSharedAttachment,    ///< Attachment not shared.
            SharedAttachment        ///< Attachment shared.
        };

        AssetLoaderTypeInfo(Candera::Appearance, CffLoaderType, CanderaObject);

        template<>
        class AssetReaderBase<Appearance>: public GenericAssetReaderBase<Appearance> {
            public:
                static bool ReadFirstPass(Appearance& appearance, LoaderContext& context);
                static bool SetShader(Appearance& appearance, AssetId shaderId, DependencyList* dependencyList, const DefaultAssetProvider* provider);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<Appearance> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<Appearance> > {
            public:
                static MemoryManagement::SharedPointer<Appearance> Create(LoaderContext& context);
        };

        AssetLoaderTypeInfo(Candera::MultiPassAppearance, CffLoaderType, Appearance);

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<MultiPassAppearance> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<MultiPassAppearance> > {
        public:
            static MemoryManagement::SharedPointer<MultiPassAppearance> Create(LoaderContext& context);
        };
    }
}

#endif  // CANDERA_APPEARANCE_BUILDER_H
