//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ANIMATIONPROPERTYSETTERFACTORY3D_H)
#define CANDERA_ANIMATIONPROPERTYSETTERFACTORY3D_H

#include <Candera/Environment.h>
#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/AnimationPropertySetterFactory.h>
#include <CanderaAssetLoader/AssetLoaderBase/ItemPathInfo.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>

namespace Candera {
    // Forward declarations
    namespace Animation {
        class AnimationPropertySetter;
    }
    class AssetProvider;
    class Camera;
#ifdef CANDERA_3D_CANVAS_ENABLED
    class CanvasRenderable;
#endif
    class Node;
    class Light;
    class MorphingMesh;
    class Material;
    class ShaderParamSetter;

    namespace Internal {
        /**
         *  @brief AnimationPropertySetterFactory3D
         */
        class AnimationPropertySetterFactory3D
        {
            FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);
        public:
            /**
             *  Assigns the AssetProvider.
             *  @param assetProvider The AssetProvider that is assigned.
             */
            static void SetAssetProvider(Candera::AssetProvider* assetProvider) { m_assetProvider = assetProvider; }

            /**
             *  Creates an AnimationPropertySetter object.
             *  @param propertyId The AnimationPropertySetterId.
             *  @param propertyName The property name.
             *  @param apcList The AnimatedPropertyChannels List.
             *  @param objectPath The object path.
             *  @param setterType The PropertySetterType, default value is pstAbsolute.
             *  @return A pointer to the AnimationPorpertySetter object.
             */
            static Animation::AnimationPropertySetter::SharedPointer CreateCorrespondingSetter(
                AnimationPropertySetterId propertyId,
                const Char* propertyName,
                const Candera::Internal::Vector<AnimatedPropertyChannels>& apcList,
                Candera::Internal::AssetId objectId,
                PropertySetterType setterType = pstAbsolute);

        private:

            static Int32 FindApsClassId(AnimationPropertySetterId propertyId, const Candera::Internal::Vector<AnimatedPropertyChannels> &apcList);

            // Generic factory
            static Animation::AnimationPropertySetter::SharedPointer CreateAnimationPropertySetterByClassId(Int32 setterId, const Char* propertyName, Candera::Internal::AssetId objectId, PropertySetterType setterType);

            // Specialized factory
            static Animation::AnimationPropertySetter::SharedPointer CreateNodePropertySetter(Int32 setterId, Node* node, PropertySetterType setterType);
            static Animation::AnimationPropertySetter::SharedPointer CreateLightPropertySetter(Int32 setterId, Light* light);
            static Animation::AnimationPropertySetter::SharedPointer CreateCameraPropertySetter(Int32 setterId, Camera* camera);
            static Animation::AnimationPropertySetter::SharedPointer CreateMorphWeightPropertySetter(const Char* propertyName, MorphingMesh* node, PropertySetterType setterType);
#ifdef CANDERA_3D_CANVAS_ENABLED
            static Animation::AnimationPropertySetter::SharedPointer CreateCanvasRenderablePropertySetter(Int32 setterId, CanvasRenderable* canvasRenderable);
#endif
            static Animation::AnimationPropertySetter::SharedPointer CreateMaterialPropertySetter(Int32 setterId, MemoryManagement::SharedPointer<Material> material, PropertySetterType setterType);
            static Animation::AnimationPropertySetter::SharedPointer CreateShaderParamSetterPropertySetter(const Char* uniformName, MemoryManagement::SharedPointer<ShaderParamSetter> shaderParamSetter, PropertySetterType setterType);

            static Candera::AssetProvider* m_assetProvider;
        };
    }
}
#endif // CANDERA_ANIMATIONPROPERTYSETTERFACTORY3D_H

