//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if  !defined(CANDERA_SCENE2DCONTEXT_H)
#define CANDERA_SCENE2DCONTEXT_H

#include <CanderaAssetLoader/AssetLoaderBase/SceneContextBase.h>

namespace Candera {

/** @addtogroup AssetLoader2D
 *  @{
 */

    // Forward declarations
    class Scene2D;
    namespace Internal {
        template <typename T>
        class AssetBuilderBase;
    }

    /**
     * @brief Encapsulates main objects that define a scene context an application can operate on.
     * These objects are:
     *  - The scene itself.
     *  - The list of widgets within the scene.
     *  - The list of attachments that can be Uploaded/Unloaded on host objects, like
     *      AnimationBlendedProperties on AnimationPlayers.
     */
    class Scene2DContext: public SceneContextBase {
    public:
        /**
         * Constructor
         * @param scene The associated Scene2D that is set.
         */
        Scene2DContext(Scene2D* scene);
        /**
         * Destructor
         */
        ~Scene2DContext();

        /**
         * Returns the associated scene.
         * @return The associated scene.
         */
        Scene2D* GetScene() { return m_scene; }

        using SceneContextBase::GetFirstWidget;
        using SceneContextBase::GetNextWidget;
        using SceneContextBase::GetWidget;        

    private:
        friend class Internal::AssetBuilderBase<Scene2DContext*>;
        Scene2D* m_scene;

        Scene2DContext(): m_scene(0) {}
        void SetScene(Scene2D* scene) { m_scene = scene; }
    };

 /** @} */ // end of AssetLoader2D

}

#endif //CANDERA_SCENE2DCONTEXT_H

