//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ASSETLOADER2DDATATYPES_H)
#define CANDERA_ASSETLOADER2DDATATYPES_H

#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderBaseDataTypes.h>
#include <Candera/EngineBase/DataTypes/CanderaObjectDataType.h>
#include <Candera/Engine2D/Core/2DStringBufferAppenders.h>

namespace Candera {
    class Image2D;
    class Node2D;
    class Camera2D;
    class RenderNode;
    class Group2D;

    namespace MetaInfo {
        namespace Internal {
            AssetLoaderDataTypeDef(Node2D*, "builtin://Node2DEditor")
            AssetLoaderDataTypeDef(Camera2D*, "builtin://Camera2DEditor")
            AssetLoaderDataTypeDef(RenderNode*, "builtin://RenderNodeEditor")
            AssetLoaderDataTypeDef(Group2D*, "builtin://Group2DEditor")


/** @addtogroup DataTypesBase
 *  @{
     */
            /**
             * @brief DataType specialization for asset referenced SharedPointer<Image2D> objects.
             *
             * @see AssetLoaderConverterToString
             */
            template<> struct DataType<Candera::MemoryManagement::SharedPointer<Image2D> > {

                static inline bool ConvertToString(const Candera::MemoryManagement::SharedPointer<Image2D>& ptr, Char *buf, UInt bufLen) {
                    return Candera::MetaInfo::CanderaObjectConverterToString<Candera::MemoryManagement::SharedPointer<Image2D> >::ConvertToString(ptr, buf, bufLen);
                };
                /**
                 * Retrieve the SharedPointer<Image2D> referenced by the item path.
                 *
                 * @param [out] image2D Pointer to the converted object.
                 * @param       buf Item path.
                 * @param       assetProvider AssetProvider used to retrieve the asset object.
                 * @return true if the item path could be converted successfully, false otherwise.
                 */
                static bool ConvertFromString(Candera::MemoryManagement::SharedPointer<Image2D> &image2D, const Char *buf, AssetProvider* assetProvider = 0);

                /**
                 * Get the PropertyEditor name as known by SceneComposer.
                 *
                 * @return string containing the SceneComposer property editor name.
                 */
                static const Char* GetEditor() { return "builtin://Image2DEditor"; }
            };

        }
/**
 * @} //end of DataTypesBase
 */

    }
}

#endif // CANDERA_ASSETLOADER2DDATATYPES_H
