//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Transformable2DAssetReader.h"
#include <Candera/Engine2D/Core/Transformable2D.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/Node2DCffReader.h>

namespace Candera {
    namespace Internal {

        bool AssetReaderBase<Transformable2D>::ReadFirstPass(Transformable2D& transformable, LoaderContext& context)
        {
            Float x = 0.0F;
            Float y = 0.0F;
            CFFReader::GetNode2DPosition(context.handle, x, y);
            transformable.SetPosition(x, y);

            CFFReader::GetNode2DScale(context.handle, x, y);
            transformable.SetScale(x, y);
            transformable.SetRotation(CFFReader::GetNode2DRotation(context.handle));

            Float xPivotOffset = 0.0F;
            Float yPivotOffset = 0.0F;
            CFFReader::GetNode2DPivotOffset(context.handle, xPivotOffset,  yPivotOffset);
            FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
            transformable.SetPivotOffset(xPivotOffset, yPivotOffset);
            FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

            Float xPivotPoint = 0.0F;
            Float yPivotPoint = 0.0F;
            CFFReader::GetNode2DPivotPoint(context.handle, xPivotPoint, yPivotPoint);
            transformable.SetPivotPoint(xPivotPoint, yPivotPoint);

            return true;
        }
    }
}
