//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TEXTNODE2D_BUILDER_H)
#define CANDERA_TEXTNODE2D_BUILDER_H

#include <Candera/Engine2D/Core/TextNode2D.h>
#include <Candera/Engine2D/Effects/Effect2D.h>

#include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/RenderNodeAssetBuilder.h>

namespace Candera {
    namespace Internal {
        AssetLoaderTypeInfo(Candera::TextNode2D, CffLoaderType, Candera::RenderNode);

        template<>
        class AssetReaderBase<TextNode2D> : public GenericAssetReaderBase<TextNode2D>{
        public:
            static bool ReadFirstPass(TextNode2D& textNode, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<TextNode2D*> : public GenericAssetBuilderBase<TextNode2D*>{
        public:
            static TextNode2D* Create(LoaderContext& context);
        };

        typedef AssetBuilderBase<TextNode2D*> TextNode2DAssetBuilder;
    }
}


#endif  // CANDERA_TEXTNODE2D_BUILDER_H
