//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SCENE2D_BUILDER_H)
#define CANDERA_SCENE2D_BUILDER_H

#include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/Node2DAssetBuilder.h>

namespace Candera {
    class Scene2D;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Scene2D, CffLoaderType, Candera::CanderaObject);

        template<>
        class AssetReaderBase<Scene2D>: public GenericAssetReaderBase<Scene2D> {
        public:
            static bool ReadFirstPass(Scene2D& scene, LoaderContext& context);
            static bool ReadSecondPass(Scene2D& scene, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Scene2D*>: public GenericAssetBuilderBase<Scene2D*> {
        public:
            static Scene2D* Create(LoaderContext& context);
        };

        typedef AssetBuilderBase<Scene2D*> Scene2DAssetBuilder;

        class SceneNode2DChildrenReader: public Node2DChildrenReader {
        protected:
            virtual Int32 GetChildrenCount(CffLoaderContext& context) const;
            virtual AssetDataHandle GetChildDataHandle(CffLoaderContext& context, Int32 index) const;
        };
    }
}


#endif  // CANDERA_SCENE2D_BUILDER_H
