//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_RENDERNODE_BUILDER_H)
#define CANDERA_RENDERNODE_BUILDER_H

#include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/Node2DAssetBuilder.h>

namespace Candera {
    class RenderNode;
    namespace Internal {
        AssetLoaderTypeInfo(Candera::RenderNode, CffLoaderType, Candera::Node2D);

        template<>
        class AssetReaderBase<RenderNode>: public GenericAssetReaderBase<RenderNode> {
        public:
            static bool ReadFirstPass(RenderNode& renderNode, LoaderContext& context);
            static bool ReadSecondPass(RenderNode& renderNode, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<RenderNode*> : public GenericAssetBuilderBase<RenderNode*> {
        public:
            static RenderNode* Create(LoaderContext& context);
        };

        typedef AssetBuilderBase<RenderNode*> RenderNodeAssetBuilder;
    }
}


#endif  // CANDERA_RENDERNODE_BUILDER_H
