//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_NODE2D_BUILDER_H)
#define CANDERA_NODE2D_BUILDER_H

#include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/Transformable2DAssetReader.h>

namespace Candera {

    namespace DynamicProperties {
        class PropertyHierarchyNode;
        class DynamicPropertyHost;
    }

    class Node2D;

    namespace Internal {

        class Node2DChildrenReader {
        public:
            bool ReadFirstPass(Node2D& node, CffLoaderContext& context) const;
            bool ReadSecondPass(Node2D& node, CffLoaderContext& context) const;
        protected:
            virtual Int32 GetChildrenCount(CffLoaderContext& context) const = 0;
            virtual AssetDataHandle GetChildDataHandle(CffLoaderContext& context, Int32 index) const = 0;
        };

        AssetLoaderTypeInfo(Candera::Node2D, CffLoaderType, Candera::Transformable2D);

        template<>
        class AssetReaderBase<Node2D>: public GenericAssetReaderBase<Node2D> {
        public:
            static bool ReadFirstPass(Node2D& node, LoaderContext& context);
            static bool ReadSecondPass(Node2D& node, LoaderContext& context);
        private:
            static bool ReadDynamicProperty(const DynamicProperties::PropertyHierarchyNode& phn, DynamicProperties::DynamicPropertyHost& host, LoaderContext& context);
        };

        template <>
        class AssetBuilder<Node2D*>: public GenericAssetBuilderBase<Node2D*> {
        public:
            static Node2D* CreateAndBuildFirstPass(LoaderContext& context);
            static bool BuildSecondPass(Node2D* node, LoaderContext& context);
            static void Dispose(Node2D* node);
        };

        typedef AssetBuilder<Node2D*> Node2DAssetBuilder;
    }
}

#endif  // CANDERA_NODE2D_BUILDER_H
