//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Group2DAssetBuilder.h"
#include <Candera/Engine2D/Core/Group2D.h>
#if defined(CANDERA_LAYOUT_ENABLED)
#include <Candera/EngineBase/Layout/Layout.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/LayouterAssetBuilder.h>
#endif
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/Group2DCffReader.h>

namespace Candera {

    using namespace Diagnostics;

    namespace Internal {

        bool AssetReaderBase<Group2D>::ReadFirstPass(Group2D& group, LoaderContext& context)
        {
            if (CFFReader::GetGroup2DIsLayoutEnabled(context.handle)) {
#if defined(CANDERA_LAYOUT_ENABLED)
                const AssetDataHandle& dataHandle = CFFReader::GetGroup2DLayout(context.handle);
                LoaderContext layouterContext = context.Clone(dataHandle);
                group.SetLayouter(AssetBuilder<Candera::Layouter*>::CreateAndBuildFirstPass(layouterContext));
#else
                FEATSTD_UNUSED2(group, context);
#endif
            }

            return true;
        }

        bool AssetReaderBase<Group2D>::ReadSecondPass(Group2D& group, LoaderContext& context)
        {
#if defined(CANDERA_LAYOUT_ENABLED)
            if (CFFReader::GetGroup2DIsLayoutEnabled(context.handle)) {
                const AssetDataHandle& layoutHandle = CFFReader::GetGroup2DLayout(context.handle);
                LoaderContext layouterContext = context.Clone(layoutHandle);
                return AssetBuilder<Layouter*>::BuildSecondPass(group.GetLayouter(), layouterContext);
            }
#else
            FEATSTD_UNUSED2(group, context);
#endif

            return true;
        }

        Group2D* Group2DAssetBuilder::Create(LoaderContext& /*context*/)
        {
            return Group2D::Create();
        }

        void Group2DAssetBuilder::Dispose(const Group2D* group)
        {
#if defined(CANDERA_LAYOUT_ENABLED)
            if (group != 0) {
                Layouter* layouter = group->GetLayouter();
                if (layouter != DefaultLayouter::GetInstance()) {
                    AssetBuilder<Layouter*>::Dispose(layouter);
                }
            }
#else
            FEATSTD_UNUSED(group);
#endif
        }
    }
}
