//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_COMPOSITEGROUP2D_BUILDER_H)
#define CANDERA_COMPOSITEGROUP2D_BUILDER_H

#include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/Group2DAssetBuilder.h>
#include <Candera/EngineBase/DynamicProperties/DynamicProperty.h>
#include <CanderaWidget/WidgetBase/WidgetBase.h>

namespace Candera {
    class CompositeGroup2D;
    namespace Internal {
        AssetLoaderTypeInfo(Candera::CompositeGroup2D, CffLoaderType, Candera::Node2D);
        
        template<>
        class AssetBuilderBase<CompositeGroup2D*>: public GenericAssetBuilderBase<CompositeGroup2D*> {
        public:
            static CompositeGroup2D* Create(const LoaderContext& context);
            static void Dispose(const CompositeGroup2D* compositeGroup);
        };

        template<>
        class AssetReaderBase<CompositeGroup2D>: public GenericAssetReaderBase<CompositeGroup2D> {
        public:
            static bool ReadSecondPass(CompositeGroup2D& compositeGroup, const LoaderContext& context);
        };

        class Composite2DInstanceBuilder {
        public:
            static bool IsValid(CompositeGroup2D*, CffLoaderContext) { return true; }
            static CompositeGroup2D* CreateAndBuildFirstPass(CffLoaderContext context);
            static bool BuildSecondPass(CompositeGroup2D* compositeGroup, CffLoaderContext context);
            static void Dispose(CompositeGroup2D* /*compositeInstance*/);
        };

        class Composite2DPropertyList {
        public:
            struct Property {
                const Char* name;
                const Char* property;
                WidgetBase* widget;
                MetaInfo::PropertyMetaInfo<WidgetBase>* metaInfo;
            };

            static Composite2DPropertyList& DefaultPropertyList();
            static const Composite2DPropertyList& GetPropertyList(const CompositeGroup2D* compositeGroup);
            static bool SetPropertyList(CompositeGroup2D* compositeGroup, const Composite2DPropertyList& propertyList);
            static bool ClearPropertyList(CompositeGroup2D* compositeGroup);
            const Property* GetProperty(const Char* name) const;
            
            Vector<Property> m_list;

            bool operator==(const Composite2DPropertyList& other) const;
        private:
            CdaDynamicProperties(CompositeGroup2D, DynamicProperties::DynamicPropertyHost);
            CdaDynamicPropertyUnregistered(PropertyList, Composite2DPropertyList);
            CdaDynamicPropertyDefaultValue(DefaultPropertyList());
            CdaDynamicPropertyEnd();
            CdaDynamicPropertiesEnd();
        };
    }
}

#endif  // CANDERA_COMPOSITEGROUP2D_BUILDER_H
