//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CAMERA2D_BUILDER_H)
#define CANDERA_CAMERA2D_BUILDER_H

#include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/Node2DAssetBuilder.h>

namespace Candera {
    class Camera2D;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Camera2D, CffLoaderType, Candera::Node2D);

        template<>
        class AssetReaderBase<Camera2D>: public GenericAssetReaderBase<Camera2D> {
        public:
            static bool ReadFirstPass(Camera2D& camera2D, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Camera2D*> : public GenericAssetBuilderBase<Camera2D*> {
        public:
            static Camera2D* Create(LoaderContext& context);
        };

        typedef AssetBuilderBase<Camera2D*> Camera2DAssetBuilder;
    }
}

#endif  // CANDERA_CAMERA2D_BUILDER_H
