//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BITMAPIMAGE2D_BUILDER_H)
#define CANDERA_BITMAPIMAGE2D_BUILDER_H

#include <Candera/Engine2D/Core/BitmapImage2D.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    class AssetProvider;
    namespace Internal {

        AssetLoaderTypeInfo(Candera::BitmapImage2D, CffLoaderType, CanderaObject);

        template<>
        class AssetReaderBase<BitmapImage2D>: public GenericAssetReaderBase<BitmapImage2D> {
            public:
                static bool ReadFirstPass(BitmapImage2D& bitmapImage, LoaderContext& context);
                static bool SetBitmap(BitmapImage2D& bitmapImage, AssetId id, DependencyList* dependencyList, const DefaultAssetProvider* provider);
        };

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<BitmapImage2D> >: public GenericAssetBuilderBase<MemoryManagement::SharedPointer<BitmapImage2D> > {
            public:
                static MemoryManagement::SharedPointer<BitmapImage2D> Create(LoaderContext& context);
        };
    }
}

#endif  // CANDERA_BITMAPIMAGE2D_BUILDER_H
