//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(CANDERA_ANIMATIONPROPERTYSETTERFACTORY2D_H)
#define CANDERA_ANIMATIONPROPERTYSETTERFACTORY2D_H

#include <Candera/Environment.h>
#include <Candera/System/Diagnostics/Log.h>
#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <CanderaAssetLoader/AssetLoaderBase/AnimationPropertySetterFactory.h>

namespace Candera {
    // Forward declarations
    class AssetProvider;

    namespace Internal {

        /**
        *  @brief AnimationPropertySetterFactory2D
        */
        class AnimationPropertySetterFactory2D
        {
            FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);
        public:
            /**
             *  Sets the asset provider.
             *  @param assetProvider The asset provider to which the value is set.
             */
            static void SetAssetProvider(Candera::AssetProvider* assetProvider) { m_assetProvider = assetProvider; }

            /**
             *  Creates an animation property setter.
             *  @param propertyId   The property id.
             *  @param propertyName The property name.
             *  @param apcList      The animated property channels list.
             *  @param objectPath   The object path.
             *  @param setterType   The property setter type, standard value = pstAbsolute.
             *  @return A pointer to the created setter
             */
            static Animation::AnimationPropertySetter::SharedPointer CreateCorrespondingSetter(AnimationPropertySetterId propertyId, const Char* propertyName, const Internal::Vector<AnimatedPropertyChannels>& apcList, Candera::Internal::AssetId objectId, PropertySetterType setterType = pstAbsolute);

        private:
            static Animation::AnimationPropertySetter::SharedPointer CreateAnimationPropertySetterByClassId(Int32 setterId, const Char* propertyName, Candera::Internal::AssetId objectId, PropertySetterType setterType = pstAbsolute);

            static Int32 FindApsClassId(AnimationPropertySetterId propertyId, const Internal::Vector<AnimatedPropertyChannels> &apcList);

            static Candera::AssetProvider* m_assetProvider;

        };
    }
}
#endif // CANDERA_ANIMATIONPROPERTYSETTERFACTORY2D_H

