//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_TextRenderer_h)
#define Candera_TextRenderer_h

#ifdef FEATSTD_THREADSAFETY_ENABLED
#include <FeatStd/Platform/CriticalSection.h>
#endif

#include <Candera/TextEngine/Style.h>
#include <Candera/TextEngine/TextRect.h>
#include <Candera/TextEngine/TextSize.h>
#include <Candera/TextEngine/TextRenderContext.h>

namespace Candera {

    namespace TextRendering {

/** @addtogroup CanderaTextEngine
 *  @{
 */

        class TextRenderContext;
        class LayoutingOptions;
        class ShapingOptions;
        class TextProperties;
        class MeasuringOptions;
        namespace Internal {
            class Parser;
            class ShaperInfo;
        }

        /**
         *  @brief TextRenderer is the core Candera function for rendering text.
         */
        class TextRenderer {
            public:
                /**
                 *  Describes if complex script parsing is disabled or enabled, and when enabled to which language
                 *  it's set.
                 */
                enum ComplexScriptParsingMode {
                    ComplexScriptsParsingDisabled,      ///< Complex script parsing disabled (For western languages etc.)
                    ArabicScript,                       ///< Enable script parsing for Arabic (RTL) language.
                    ComplexScriptParsingModeCount       ///< Number of complex script parsing modes.
                };

                /**
                 *  Flags of text size, whether text includes or excludes the final horizontal advance.
                 */
                enum TextSizeFlags {
                    TextSizeIncludeFinalAdvance = 0,        ///< GetTextSize will return the text width including the final horizontal advance.
                    TextSizeExcludeFinalAdvance = 1,        ///< GetTextSize will return the text width excluding the final horizontal advance.
                    TextSizeDefaults = TextSizeIncludeFinalAdvance  ///< Default is TextSizeIncludeFinalAdvance.
                };

                /**
                 *  Flags of text size, whether text includes or excludes the final vertical advance.
                 */
                enum TextSizeVerticalFlags {
                    TextSizeVerticalConstantHeight = 0,  ///< GetTextSize will return the text height retrieved from the font global metrics.
                    TextSizeVerticalActualHeight = 1,   ///< GetTextSize will return the current text height.
                    TextSizeVerticalDefaults = TextSizeVerticalConstantHeight ///< Default is TextSizeVerticalConstantHeight.
                };

                /**
                 *  Render shaped and layouted text.
                 *  @param context The rendering context used to generate
                 *      and render the glyphs. See TextRenderContext.
                 *  @param layoutingOptions Options used for layout the 
                 *      text. See LayoutingOptions.
                 *  @param shapingOptions Options used for shaping the text. 
                 *      See ShapingOptions.
                 *  @param textProperties An object describing the text. 
                 *      See TextProperties.
                 *  @return The bounding rectangle.
                 */
                bool Render(
                    TextRenderContext &context, 
                    const LayoutingOptions& layoutingOptions,
                    const ShapingOptions& shapingOptions,
                    const TextProperties& textProperties) const;

        };
        namespace Internal {
            class TextRenderLocks {
            public:
#ifdef FEATSTD_THREADSAFETY_ENABLED
                static FeatStd::Internal::CriticalSection* GetGlyphLock();
#endif
            private:
                FEATSTD_MAKE_CLASS_STATIC(TextRenderLocks);
                FEATSTD_MAKE_CLASS_UNCOPYABLE(TextRenderLocks);
            };
        }

 /** @} */ // end of CanderaTextEngine

    }   // namespace TextRendering

}   // namespace Candera

#endif  // Candera_TextRenderer_h
