//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PreprocessedGlyphData.h"

#include <FeatStd/Util/StaticObject.h>

namespace Candera {
    namespace TextRendering {


        const Candera::TextRendering::PreprocessedGlyphData& PreprocessedGlyphData::GetInvalidGlyphData()
        {
            FEATSTD_SYNCED_STATIC_OBJECT(PreprocessedGlyphData, s_invalidGlyph);
            return s_invalidGlyph;
        }

        PreprocessedGlyphData::PreprocessedGlyphData() :
            m_glyphIndex(0),
            m_characterPosition(0),
            m_memoryPosition(0),
            m_width(0),
            m_xadvance(0),
            m_directionRTL(false)
        {
            m_fontIdentifier.m_value = -1;
            m_position.x = 0;
            m_position.y = 0;
        }

        Candera::TextRendering::FontIdentifier PreprocessedGlyphData::GetFontIdentifier() const
        {
            return m_fontIdentifier;
        }

        Candera::TextRendering::GlyphIndex PreprocessedGlyphData::GetGlyphIndex() const
        {
            return m_glyphIndex;
        }

        Candera::TextRendering::TextPosition PreprocessedGlyphData::GetCharacterPosition() const
        {
            return m_characterPosition;
        }

        Candera::TextRendering::TextPosition PreprocessedGlyphData::GetMemoryPosition() const
        {
            return m_memoryPosition;
        }

        Candera::TextRendering::PixelPosition2D PreprocessedGlyphData::GetPosition() const
        {
            return m_position;
        }

        Candera::TextRendering::PixelPosition PreprocessedGlyphData::GetWidth() const
        {
            return m_width;
        }

        Candera::TextRendering::PixelPosition PreprocessedGlyphData::GetXAdvance() const
        {
            return m_xadvance;
        }

        bool PreprocessedGlyphData::GetDirectionRTL() const
        {
            return m_directionRTL;
        }

        void PreprocessedGlyphData::SetFontIdentifier(FontIdentifier fontIdentifier)
        {
            m_fontIdentifier = fontIdentifier;
        }

        void PreprocessedGlyphData::SetGlyphIndex(GlyphIndex glyphIndex)
        {
            m_glyphIndex = glyphIndex;
        }

        void PreprocessedGlyphData::SetCharacterPosition(TextPosition characterPosition)
        {
            m_characterPosition = characterPosition;
        }

        void PreprocessedGlyphData::SetMemoryPosition(TextPosition memoryPosition)
        {
            m_memoryPosition = memoryPosition;
        }

        void PreprocessedGlyphData::SetPosition(PixelPosition2D position)
        {
            m_position = position;
        }


        void PreprocessedGlyphData::SetPosition(PixelPosition x, PixelPosition y)
        {
            m_position.x = x;
            m_position.y = y;
        }


        void PreprocessedGlyphData::IncPosition(PixelPosition x, PixelPosition y)
        {
            m_position.x += x;
            m_position.y += y;
        }

        void PreprocessedGlyphData::SetWidth(PixelPosition width)
        {
            m_width = width;
        }

        void PreprocessedGlyphData::SetXAdvance(PixelPosition xadvance)
        {
            m_xadvance = xadvance;
        }

        void PreprocessedGlyphData::SetDirectionRTL(bool isRTL)
        {
            m_directionRTL = isRTL;
        }

        bool PreprocessedGlyphData::IsInvalidGlyph() const
        {
            return m_glyphIndex == 0;
        }

        void PreprocessedGlyphData::InvalidateGlyph()
        {
            m_glyphIndex = 0;
            m_position.x = 0;
            m_position.y = 0;
            m_width = 0;
            m_xadvance = 0;
        }

        Candera::TextRendering::PixelPosition PreprocessedGlyphData::GetXSpacing() const
        {
            return m_xadvance - m_width;
        }

        bool PreprocessedGlyphData::operator==(PreprocessedGlyphData const& glyph) const
        {
            return (m_glyphIndex == glyph.m_glyphIndex) &&
                (m_position == glyph.m_position) &&
                (m_fontIdentifier == glyph.m_fontIdentifier);
        }

    }
}

