//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "NestedTextLayoutStrategy.h"
#include <Candera/TextEngine/TextLayoutStrategy.h>

namespace Candera {
    namespace TextRendering {


        Candera::TextRendering::TextLayoutStrategy::Action NestedTextLayoutStrategy::OnInit(Pass pass)
        {
            Action action = Continue;
            SizeType i = 0;
            while (i < m_strategies.Size()) {
                action = m_strategies[i]->OnInit(pass);
                if (action != Continue) {
                    break;
                }
                ++i;
            }
            return action;
        }

        Candera::TextRendering::TextLayoutStrategy::Action NestedTextLayoutStrategy::OnLineBreak(const Char* textCursor, LineBreakType type)
        {
            Action action = Continue;
            SizeType i = 0;
            while (i < m_strategies.Size()) {
                action = m_strategies[i]->OnLineBreak(textCursor, type);
                if (action != Continue) {
                    break;
                }
                ++i;
            }
            return action;
        }

        Candera::TextRendering::TextLayoutStrategy::Action NestedTextLayoutStrategy::OnGlyphProcessing(TextPosition textPosition)
        {
            Action action = Continue;
            SizeType i = 0;
            while (i < m_strategies.Size()) {
                action = m_strategies[i]->OnGlyphProcessing(textPosition);
                if (action != Continue) {
                    break;
                }
                ++i;
            }
            return action;
        }

        void NestedTextLayoutStrategy::AddStrategy(TextLayoutStrategy* strategy)
        {
            static_cast<void>(m_strategies.Add(strategy));
        }

    }
}
