//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_TextEngine_LineBreakLayoutStrategy_h
#define Candera_TextEngine_LineBreakLayoutStrategy_h


#include <Candera/Environment.h>
#include <Candera/TextEngine/Types.h>
#include <Candera/TextEngine/TextLayoutStrategy.h>


namespace Candera {
    namespace TextRendering {
        /** @addtogroup CanderaTextEngine
        *  @{
        */
        class ILayoutStrategyDelegate;
        /**
        * @brief This strategy provides an ILayoutStrategyDelegate object (most probably a context) with linebreak information.
        * So when does a linebreak come.
        * it additionally informs the object about a new char which will be processed afterwards. The object can influence whether the glyph is
        * processed or not.
        */
        class LineBreakLayoutStrategy : public TextLayoutStrategy {
        public:
            LineBreakLayoutStrategy(ILayoutStrategyDelegate& context);

            /**
            * Does nothing here (Interface compliance)
            */
            virtual Action OnInit(Pass);

            /**
            * delegates the information about a linebreak to the context and checks if the context wants to stop processing
            * @param textCursor is the current character.
            * @param type of linebreak
            */
            virtual Action OnLineBreak(const Char* textCursor, LineBreakType type);

            /**
            * Delegates the information of handling a new glyph to the context
            * @param textpos is the current position within the text
            */
            virtual Action OnGlyphProcessing(TextPosition textpos);

        private:
            ILayoutStrategyDelegate& m_context;

            FEATSTD_MAKE_CLASS_UNCOPYABLE(LineBreakLayoutStrategy);
        };
        /** @} */ // end of CanderaTextEngine

    }// namespace TextRendering
}// namespace Candera
#endif // Candera_TextEngine_LineBreakLayoutStrategy_h
