//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Candera_TextEngine_TextEngineMemoryPool_h)
    #define Candera_TextEngine_TextEngineMemoryPool_h

#include <Candera/Environment.h>
#include <FeatStd/Platform/Types.h>

#if defined(FEATSTD_ENABLE_MEMORYPOOL_ALLOCATIONS)
    #include <FeatStd/MemoryPool/MemoryPool.h>
#else
    #include <FeatStd/MemoryManagement/Heap.h>
#endif

namespace Candera { namespace TextRendering {

    /** @addtogroup CanderaTextEngine
     *  @{
     */

#if defined(FEATSTD_ENABLE_MEMORYPOOL_ALLOCATIONS)

    /// alloc for text engine allocations
    #define TEXTENGINE_ALLOC(nBytes) \
        FEATSTD_MEMORYPOOL_ALLOC(Candera::TextRendering::MemoryPool, FeatStd::UInt8(FeatStd::MemoryManagement::MemAttrib::Transient), (nBytes))

    /// realloc for text engine allocations
    #define TEXTENGINE_REALLOC(buffer, newSize) \
        FEATSTD_MEMORYPOOL_REALLOC(Candera::TextRendering::MemoryPool, buffer, newSize)

    /// free for text engine allocations
    #define TEXTENGINE_FREE(buffer) \
        FEATSTD_MEMORYPOOL_FREE(Candera::TextRendering::MemoryPool, buffer)

    /// Transient new for text engine allocations
    #define TEXTENGINE_TRANSIENT_NEW(type) \
        FEATSTD_MEMORYPOOL_TRANSIENT_NEW(Candera::TextRendering::MemoryPool, type)

    /// Transient new[] for text engine allocations
    #define TEXTENGINE_TRANSIENT_NEW_ARRAY(type, count) \
        FEATSTD_MEMORYPOOL_ARRAY_NEW(Candera::TextRendering::MemoryPool, FeatStd::MemoryManagement::MemAttrib::Transient, type, (count))

    /// Permanent new for text engine allocations
    #define TEXTENGINE_PERMANENT_NEW(type) \
        FEATSTD_MEMORYPOOL_PERMANENT_NEW(Candera::TextRendering::MemoryPool, type)

    /// Permanent new[] for text engine allocations
    #define TEXTENGINE_PERMANENT_NEW_ARRAY(type, count) \
        FEATSTD_MEMORYPOOL_ARRAY_NEW(Candera::TextRendering::MemoryPool, FeatStd::MemoryManagement::MemAttrib::Permanent, type, (count))

    /// delete for text engine allocations
    #define TEXTENGINE_DELETE(p)       FEATSTD_MEMORYPOOL_DELETE(p)

    /// delete[] for text engine allocations
    #define TEXTENGINE_DELETE_ARRAY(p) FEATSTD_MEMORYPOOL_ARRAY_DELETE(p)

    #if defined(CANDERA_TEXTENGINE_MEMORYPOOL_ENABLED)
        /// Define a dedicated memory pool for text engine allocations.
        extern bool InitTextEngineMemoryPool();
        FEATSTD_MEMORYPOOL_DEFINE_MANAGED_MEMORYPOOL(MemoryPool, InitTextEngineMemoryPool);
    #else
        /// use the default memory pool
        typedef FeatStd::DefaultMemoryPool MemoryPool;
    #endif

#else
    /// alloc for text engine allocations
    #define TEXTENGINE_ALLOC(nBytes)                        FEATSTD_ALLOC(nBytes)

    /// realloc for text engine allocations
    #define TEXTENGINE_REALLOC(buffer, nBytes)              FEATSTD_REALLOC(buffer, nBytes)

    /// free for text engine allocations
    #define TEXTENGINE_FREE(buffer)                         FEATSTD_FREE(buffer)

    /// Transient new for text engine allocations
    #define TEXTENGINE_TRANSIENT_NEW(type)                  FEATSTD_NEW(type)

    /// Transient new[] for text engine allocations
    #define TEXTENGINE_TRANSIENT_NEW_ARRAY(type, count)     FEATSTD_NEW_ARRAY(type, (count))

    /// Permanent new
    #define TEXTENGINE_PERMANENT_NEW(type)                  FEATSTD_NEW(type)

    /// Permanent new[] for text engine allocations
    #define TEXTENGINE_PERMANENT_NEW_ARRAY(type, count)     FEATSTD_NEW_ARRAY(type, (count))

    /// delete for text engine allocations
    #define TEXTENGINE_DELETE(p)                            FEATSTD_DELETE(p)

    /// delete[] for text engine allocations
    #define TEXTENGINE_DELETE_ARRAY(p)                      FEATSTD_DELETE_ARRAY(p)

#endif

    /** @} */ // end of AssetLoaderBase
}}

#endif // Candera_TextEngine_TextEngineMemoryPool_h
