//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TEXTENGINEDATATYPES_H)
#define CANDERA_TEXTENGINEDATATYPES_H

#include <Candera/Environment.h>
#include <Candera/System/MetaInfo/DataType.h>
#include <Candera/TextEngine/TextEngineStringBufferAppenders.h>

namespace Candera {

    namespace TextRendering {
        class Font;
    }

    namespace MetaInfo {

/** 
 * @addtogroup DataTypesTextEngine
 * @{ 
 */

        /**
         * @brief DataType specialization for TextRendering::Font.
         * 
         * The string representation of a Node consists of the font name and the font height,
         *  followed by an optional index in TTC, e.g. "arial.ttc;10;1". The font name is arial.ttc,
         *  its height is 10, and the index of the face is 1 (bold, for example).
         */
        template<> struct DataType<TextRendering::Font> {
            /**
             * Convert a Font to its string representation.
             * 
             * @param val Font to convert.
             * @param buf Buffer to write the string representation.
             * @param bufLen Buffer length.
             * @return true if conversion successful, false otherwise.
             */
            static bool ConvertToString(const TextRendering::Font &val, Char *buf, UInt bufLen);
            
            /**
             * Convert the string representation to a Font.
             * 
             * @param val converted Font.
             * @param buf Buffer that contains the string representation.
             * @return true if conversion successful, false otherwise.
             */
            static bool ConvertFromString(TextRendering::Font &val, const Char *buf);
                        
            /**
             * Get the PropertyEditor name as known by SceneComposer.
             * 
             * @return string containing the SceneComposer property editor name.
             */
            static const Char* GetEditor() { return "builtin://FontEditor"; }

        };
        
        /**
         * @} //end of DataTypesTextEngine
         */

    }   // namespace MetaInfo
}   // namespace Candera

#endif  // CANDERA_TEXTENGINEDATATYPES_H
